import logging


class Logger(object):
    def __init__(self, name="logger", level=logging.INFO):
        self.logger = logging.getLogger(name)
        self.logger.setLevel(level)
        logging.basicConfig(
            filename=f"{name}.log",
            level=level,
            format="%(asctime)s.%(msecs)03d %(levelname)s %(module)s - %(funcName)s: %(message)s",
            datefmt="%Y-%m-%d %H:%M:%S",
        )

    def debug(self, msg, wandb_record=None):
        self.logger.debug(msg)

    def info(self, msg, wandb_record=None):
        self.logger.info(msg)

    def warning(self, msg, wandb_record=None):
        self.logger.warning(msg)

    def error(self, msg, wandb_record=None):
        self.logger.error(msg)


if __name__ == "__main__":
    log = Logger()
    log.debug("debug")
    log.info("info")
    log.warning("warning")
    log.error("error")
